def read_dataset(file_name, ontology, remove_isolated=True, add_dummy_node=False):
    nx_graph_list = []
    nx_graph_list_event_only = []
    sink_nodes_list = []
    source_nodes_list = []
    for line in open(file_name,'r'):
        line = line.rstrip('\n')
        graph_obj = json.loads(line)
        # print(graph_obj)
        instance_graph = graph_obj['schemas'][0]
        if len(graph_obj['schemas']) != 1:
            # print('wrong instance graph lens', len(graph_obj['schemas']))
            continue
        G = nx.DiGraph() 
        add_entity_nodes(instance_graph, G, ontology)
        event_nodes = add_event_nodes(instance_graph, G, ontology)
        add_temporal_order(instance_graph, G, ontology)
        add_entity_relations(instance_graph, G, ontology)

        
        # event_only_graph
        G_event_only = nx.DiGraph(G.subgraph(event_nodes))
        if remove_isolated:
            # remove isolated events
            isolated_events = list(nx.isolates(G_event_only))
            G_event_only.remove_nodes_from(isolated_events)
        

        # remove_isolated
        if remove_isolated:
            # remove isolated events
            G.remove_nodes_from(isolated_events)        
            # remove other isoloated nodes
            G.remove_nodes_from(list(nx.isolates(G)))

        # find sink nodes
        nodes_in_degree_zero = [node for node,degree in dict(G_event_only.in_degree()).items() if degree == 0]
        nodes_out_degree_zero = [node for node,degree in dict(G_event_only.out_degree()).items() if degree == 0]
        source_nodes_list.append(nodes_in_degree_zero)
        sink_nodes_list.append(nodes_out_degree_zero)

        # add_dummy_node
        if add_dummy_node:
            # add start node
            name = 'DUMMY_0'
            type = 'Start.Start.Start'
            type_idx = ontology.event2idx[type]
            G.add_node(name, type=type_idx)
            G_event_only.add_node(name, type=type_idx)
            # add temporal edges for all starting nodes
            for node_in_degree_zero in nodes_in_degree_zero:
                G.add_edge(name, node_in_degree_zero, type=ontology.TEMP_EDGE_IDX)
                G_event_only.add_edge(name, node_in_degree_zero, type=ontology.TEMP_EDGE_IDX)

            # add end nodes
            name = 'DUMMY_1'
            type = 'End.End.End'
            type_idx = ontology.event2idx[type]
            G.add_node(name, type=type_idx)
            G_event_only.add_node(name, type=type_idx)
            # add temporal edges for all starting nodes
            for node_out_degree_zero in nodes_out_degree_zero:
                G.add_edge(node_out_degree_zero, name, type=ontology.TEMP_EDGE_IDX)
                G_event_only.add_edge(node_out_degree_zero, name, type=ontology.TEMP_EDGE_IDX)
            
        nx_graph_list_event_only.append(G_event_only)
        nx_graph_list.append(G)

    return nx_graph_list, nx_graph_list_event_only, source_nodes_list, sink_nodes_list

def add_entity_nodes(instance_graph, G, ontology):
    for ent in instance_graph['entities']:
        name = ent['@id']
        type = ent['entityTypes'].split('/')[-1]
        type_idx = ontology.entity2idx[type]

        G.add_node(name, type=type_idx)

def add_event_nodes(instance_graph, G, ontology):
    event_nodes = list()
    for event in instance_graph['steps']:
        name = event['@id']
        type = event['@type'].split('/')[-1]
        type_idx = ontology.event2idx[type]
        G.add_node(name, type=type_idx)
        for p in event['participants']:
            e_type = p['role'].split('/')[-1]
            e_idx = ontology.arg2idx[e_type]
            for v in p['values']:
                v_name = v['entity']
                G.add_edge(name, v_name, type=e_idx)
                # G.add_edge(v_name, name, type=e_idx) 
        event_nodes.append(name)
    return event_nodes

def add_temporal_order(instance_graph, G,ontology):
    for order in instance_graph['order']:
        b_name = order['before']
        a_name = order['after']
        G.add_edge(b_name, a_name, type=ontology.TEMP_EDGE_IDX)

def add_entity_relations(instance_graph, G, ontology):
    for rel in instance_graph['entityRelations']:
        sub_name = rel['relationSubject']
        r_type = rel['relations']['relationPredicate'].split('/')[-1]
        r_type = relation_naming(r_type)
        r_type_idx = ontology.rel2idx[r_type]
        obj_name = rel['relations']['relationObject']
        G.add_edge(sub_name, obj_name, type=r_type_idx)

def relation_naming(relation_type_str):
    relation_type_core = relation_type_str.split('/')[-1]
    if len(relation_type_core.split('.')) == 2:
        if relation_type_core.endswith('Resident'):
            relation_type_str = relation_type_str + '.Resident'
        elif relation_type_core.endswith('OrganizationHeadquarters'):
            relation_type_str = relation_type_str + '.OrganizationHeadquarters'
        elif relation_type_core.endswith('Founder'):
            relation_type_str = relation_type_str + '.Founder'
        elif relation_type_core.endswith('Make'):
            relation_type_str = relation_type_str + '.Make'
        elif relation_type_core.endswith('Color'):
            relation_type_str = relation_type_str + '.Color'
        elif relation_type_core.endswith('StudentAlum'):
            return None
        else:
            relation_type_str = relation_type_str + '.Unspecified'
    return relation_type_str